import numpy as np
from matplotlib import pyplot as plt
import matplotlib
from matplotlib.patches import Polygon
from matplotlib.collections import PatchCollection
import matplotlib.gridspec as gridspec

#####################################################################################################################################################################
#   Code for producing Figure 3--Figure Supplement 4.
#   The following data is used in this figure:
#   -- theoryConstdiffxz_2pN.txt, x-z projection of the diffusion contour for the constrained diffusion theory with \mu_c = 5 k_B T and 2 pN backward force
#   -- theoryConstdiffxy_2pN.txt, x-y projection of the diffusion contour for the constrained diffusion theory with \mu_c = 5 k_B T and 2 pN backward force
#   -- theoryConstdiffyz_2pN.txt, y-z projection of the diffusion contour for the constrained diffusion theory with \mu_c = 5 k_B T and 2 pN backward force
#   -- theoryConstdiffrz_2pN.txt, r-z projection of the diffusion contour for the constrained diffusion theory with \mu_c = 5 k_B T and 2 pN backward force
#
#   -- cont_xz_5kbT_2pN.txt, x-z projection of the diffusion contour measured in BD simulations with \mu_c = 5 k_B T and 2 pN backward force
#   -- cont_xy_5kbT_2pN.txt, x-y projection of the diffusion contour measured in BD simulations with \mu_c = 5 k_B T and 2 pN backward force
#   -- cont_yz_5kbT_2pN.txt, y-z projection of the diffusion contour measured in BD simulations with \mu_c = 5 k_B T and 2 pN backward force
#   -- cont_rz_5kbT_2pN.txt, r-z projection of the diffusion contour measured in BD simulations with \mu_c = 5 k_B T and 2 pN backward force
#
#####################################################################################################################################################################



maxLevel = 6.5
levels = np.linspace(-0.00000000001*10**(-4),maxLevel*10**(-4),2*maxLevel+1)
print(levels)
axisLabelSize = 18
pltLabelSize=15

params = {'backend': 'ps'}

plt.rcParams.update(params)


fig = plt.figure(figsize=(17, 7.5))




outer = gridspec.GridSpec(9, 9, wspace=1.,hspace=1.)

theory = gridspec.GridSpecFromSubplotSpec(1, 4,
                    subplot_spec=outer[:4,1:], wspace=0.3)

cbar = gridspec.GridSpecFromSubplotSpec(1, 1,
                    subplot_spec=outer[1:7,0])


simulation = gridspec.GridSpecFromSubplotSpec(1, 4,
                    subplot_spec=outer[5:,1:], wspace=0.3)


ax = plt.Subplot(fig, theory[0, 0])
fig.add_subplot(ax)

z, x, probxz = np.transpose(np.loadtxt('theory_diffusion_contours/theoryConstDiffxz_2pN.txt'))

numz = np.count_nonzero(z==z[1])
numx = np.count_nonzero(x==x[1])
z = z[::numz]
x = x[:int(len(x)/numx)]
probxz = np.transpose(np.reshape(probxz,[numx, numz]))
probxz = probxz

colorBarAxs = ax.contourf(z,x, probxz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z,x, probxz, levels, colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$x$', size=axisLabelSize,labelpad=-5)
ax.text(0.99,0.99, r'$\mathcal{P}(x,z)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.text(0.01, 0.01, r'$\mu_c = 5$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='left', verticalalignment='bottom')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'A', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')

ax = plt.Subplot(fig, theory[0, 1])
fig.add_subplot(ax)
ax.set_title(r'Analytical Theory', size=26, y=1.05,x=1.05)
x, y, probxy = np.transpose(np.loadtxt('theory_diffusion_contours/theoryConstDiffxy_2pN.txt'))

numx = np.count_nonzero(x==x[1])
numy = np.count_nonzero(y==y[1])
x = x[::numx]
y = y[:int(len(y)/numy)]
probxy = np.reshape(probxy,[numy, numx])

ax.contourf(y,x, probxy, levels, cmap=plt.cm.YlOrBr)
ax.contour(y,x, probxy, levels,colors='k')
ax.set_xlabel(r'$y$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$x$', size=axisLabelSize,labelpad=-5)
ax.text(0.99,0.99, r'$\mathcal{P}(x,y)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'B', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')


ax = plt.Subplot(fig, theory[0, 2])
fig.add_subplot(ax)

z, y, probyz = np.transpose(np.loadtxt('theory_diffusion_contours/theoryConstDiffyz_2pN.txt'))

numy = np.count_nonzero(y==y[1])
numz = np.count_nonzero(z==z[1])
z = z[::numz]
y = y[:int(len(y)/numy)]
probyz = np.transpose(np.reshape(probyz,[numy, numz]))

ax.contourf(z,y, probyz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z, y, probyz, levels, colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$y$', size=axisLabelSize,labelpad=-5)
ax.text(0.99,0.99, r'$\mathcal{P}(y,z)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'C', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')

ax = plt.Subplot(fig, theory[0, 3])
fig.add_subplot(ax)


z, r, probrz = np.transpose(np.loadtxt('theory_diffusion_contours/theoryConstDiffrz_2pN.txt'))

numz = np.count_nonzero(z==z[1])
numr = np.count_nonzero(r==r[1])
z = z[::numz]
r = r[:int(len(r)/numr)]
probrz = np.transpose(np.reshape(probrz,[numr, numz]))


ax.contourf(z,r, probrz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z,r, probrz, levels,colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$\rho$', size=axisLabelSize,labelpad=-3)
ax.text(0.99,0.99, r'$\mathcal{P}(z,\rho)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.set_yticks([0,25,50,75])
ax.text(0.01, 0.99, 'D', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')



ax = plt.Subplot(fig, simulation[0, 0])
fig.add_subplot(ax)

z, x, probxz = np.transpose(np.loadtxt('BD_diffusion_contours/cont_xz_5kbT_2pN.txt'))

numz = np.count_nonzero(z==z[1])
numx = np.count_nonzero(x==x[1])
z = z[:int(len(z)/numz)]
x = x[::numx]
probxz = np.reshape(probxz,[numz, numx])

ax.contourf(z, x, probxz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z, x, probxz, levels, colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$x$', size=axisLabelSize,labelpad=-2)
ax.text(0.99, 0.99, r'$\mathcal{P}(x,z)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'E', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')



ax = plt.Subplot(fig, simulation[0, 1])
fig.add_subplot(ax)
ax.set_title(r'Brownian Dynamics Simulations', size=26, y=1.05, x=1.1)


y, x, probxy = np.transpose(np.loadtxt('BD_diffusion_contours/cont_xy_5kbT_2pN.txt'))

numy = np.count_nonzero(y==y[1])
numx = np.count_nonzero(x==x[1])
y = y[:int(len(y)/numy)]
x = x[::numx]
probxy = np.reshape(probxy,[numy, numx])

ax.contourf(y, x, probxy, levels, cmap=plt.cm.YlOrBr)
ax.contour(y, x, probxy, levels, colors='k')
ax.set_xlabel(r'$y$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$x$', size=axisLabelSize,labelpad=-2)
ax.text(0.99, 0.99, r'$\mathcal{P}(y,x)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'F', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')


ax = plt.Subplot(fig, simulation[0, 2])
fig.add_subplot(ax)


z, y, probyz = np.transpose(np.loadtxt('BD_diffusion_contours/cont_yz_5kbT_2pN.txt'))

numz = np.count_nonzero(z==z[1])
numy = np.count_nonzero(y==y[1])
z = z[:int(len(z)/numz)]
y = y[::numy]
probyz = np.reshape(probyz,[numz, numy])

ax.contourf(z, y, probyz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z, y, probyz, levels, colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$y$', size=axisLabelSize,labelpad=-5)
ax.text(0.99, 0.99, r'$\mathcal{P}(y,z)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.text(0.01, 0.99, 'G', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')


ax = fig.add_subplot(simulation[0, 3])


z, r, probrz = np.transpose(np.loadtxt('BD_diffusion_contours/cont_rz_5kbT_2pN.txt'))

numz = np.count_nonzero(z==z[1])
numr = np.count_nonzero(r==r[1])
z = z[:int(len(z)/numz)]
r = r[::numr]
probrz = np.reshape(probrz,[numz, numr])

ax.contourf(z, r, probrz, levels, cmap=plt.cm.YlOrBr)
ax.contour(z, r, probrz, levels, colors='k')
ax.set_xlabel(r'$z$', size=axisLabelSize,labelpad=0)
ax.set_ylabel(r'$\rho$', size=axisLabelSize,labelpad=-5)
ax.text(0.99, 0.99, r'$\mathcal{P}(z, \rho)$', size=pltLabelSize, transform=ax.transAxes, horizontalalignment='right', verticalalignment='top')
ax.locator_params(nbins=5)
ax.set_yticks([0, 25, 50, 75])
ax.text(0.01, 0.99, 'H', size=pltLabelSize, transform=ax.transAxes,
              horizontalalignment='left', verticalalignment='top')


ax = fig.add_subplot(cbar[:,:])

norm= matplotlib.colors.Normalize(0, max(levels)*10**4)
sm = plt.cm.ScalarMappable(norm=norm, cmap=plt.cm.YlOrBr)
sm.set_array([])

cbar = fig.colorbar(sm, ticks=range(int(max(levels)*10**4)+1), cax=ax, label=r'Probability ($\times 10^{-4}$)')
cbar.ax.tick_params(labelsize=18)
cbar.ax.set_yticklabels(range(int(max(levels)*10**4)+1))
cbar.ax.yaxis.set_ticks_position('left')
cbar.ax.yaxis.set_label_position('left')
cbar.ax.yaxis.label.set_size(20)

plt.savefig('diffusion_figure_force_dependence.pdf',bbox_inches='tight')

plt.show()


